/******************************************************************************\
**
**     COMPANY:	LDW Software
**
**      MODULE:	DoorKey
**
** DESCRIPTION:	Door key puzzle
**
**      AUTHOR:	Adrian Francis
**
\******************************************************************************/

#ifndef DOORKEY_H
#define DOORKEY_H

/******************************************************************************\
** LIBRARY INCLUDES
\******************************************************************************/
#include "ldwImage.h"
#include "Puzzle.h"
#include "../Collectables/CollectableInterface.h"
#include "../Game/TechObserverInterface.h"

/******************************************************************************\
** CONSTANT DEFINITIONS
\******************************************************************************/
const int DoorKey_c_iChanceOfJumpSuccess = 80;
const ldwPoint DoorKey_c_sClamPos(1830, 235);
const ldwPoint DoorKey_c_sBrokenPearlPos(316+512,16+512);
const ldwPoint DoorKey_c_sRoughPearlPos(228,321+512);
const ldwPoint DoorKey_c_sPolishedPearlPos(182+512,408+512*2);
const int DoorKey_c_iNumPossiblePearlPositions = 16;
const int DoorKey_c_iAshKeyTime = 61 * 60 * 60;

/******************************************************************************\
** CLASS DEFINITIONS
\******************************************************************************/
class CDoorKey : public IPuzzle, public ICollectable, ITechObserver
{
	friend class CPuzzle;

private:

	//class enumerations
	enum ERef
	{
		eRef_Key1 = ePuzzle_DoorKey + (1 << 16),
		eRef_Key2 = ePuzzle_DoorKey + (2 << 16),
		eRef_Key3 = ePuzzle_DoorKey + (3 << 16),
		eRef_Pearl = ePuzzle_DoorKey + (4 << 16)
	};

	enum 
	{
		ePearl_Irregular,
		ePearl_Rough,
		ePearl_Polished
	};

public:

	enum EKey
	{
		eKey_Fire = 0,
		eKey_Tree,
		eKey_Clam,

		eKey_NumberOf
	};

	//class structures
	struct SKey
	{
		ldwPoint	m_sPos;
		bool		m_bWasCollected;
	};

	struct SSaveState
	{
		SKey		m_sKey[eKey_NumberOf];
		int			m_iPearlState;
	};

private:

	//class data
	static const ldwPoint scm_sPossiblePearlPosition[DoorKey_c_iNumPossiblePearlPositions];

	int				m_iClamFrame;
	int				m_iPearlState;

	SKey			m_sKey[3];
	int				m_iPearlPos;

	ldwImageGrid *	m_pClam;
	ldwImageGrid *	m_pDoorKeys;
	
	//class methods
	//setup
	public:		CDoorKey(void);
	public:		void Reset();
	public:		void LoadAssets();
	public:		void ReleaseAssets();
	public:		const int LoadState(const unsigned char *pData);
	public:		const int SaveState(const unsigned char *pData, const int iMaxDataSize) const;

	// process
	public:		void Refresh();
	public:		void Draw() const;
	public:		void Draw(const int iRef) const;
	public:		void Update();
	public:		void Complete();

	public:		const bool Carry(CVillager &Villager, const ECarrying eCarrying);
	public:		void Drop(CVillager &Villager, const ECarrying eCarrying);

	public:		void TechAdvanced(const ETech eTech, const int iLevel);

	// access
	public:		const ECarrying GetNearbyCollectable(CVillager &Villager, const ldwPoint sPos);
	public:		const int KeysCollected() const;
	public:		const bool IsNearClam(const ldwPoint sPos) const;
	public:		const bool IsNearPearl(const ldwPoint sPos) const;

	public:		const bool HotDiamondInFirePit() const;

	private:    const bool IsNearRoughPearl(const ldwPoint sPos) const;
	private:    const bool IsNearBrokenPearl(const ldwPoint sPos) const;
	
};

/******************************************************************************\
** GLOBAL DECLARATIONS
\******************************************************************************/
extern CDoorKey		DoorKey;

#endif

/******************************************************************************\
** END OF FILE
\******************************************************************************/